% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr_access.R
\name{get_branches_heights}
\alias{dendextend_get_branches_heights}
\alias{get_branches_heights}
\title{Get height attributes from a dendrogram}
\usage{
get_branches_heights(dend, sort = TRUE, decreasing = FALSE, ...)
}
\arguments{
\item{dend}{a dendrogram.}

\item{sort}{logical. Should the heights be sorted?}

\item{decreasing}{logical. Should the sort be increasing or decreasing? Not available for partial sorting.}

\item{...}{not used.}
}
\value{
a vector of the dendrogram's nodes heights (excluding leaves).
}
\description{
Get height attributes of a dendrogram's branches
}
\examples{

hc <- hclust(dist(USArrests[1:4,]), "ave")
dend <- as.dendrogram(hc)
get_branches_heights(dend)

\dontrun{
dat1 <- iris[1:150,-5]
dat1 <- rbind(dat1,dat1,dat1,dat1,dat1,dat1,dat1)
dend = as.dendrogram(hclust(dist(dat1)))
library(microbenchmark)
library(dendextendRcpp)
microbenchmark(
   dendextendRcpp::dendextendRcpp_get_branches_heights(dend),
   old_get_branches_heights(dend,sort=F)
)
}

}

