% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jump.locator.R
\name{jump.locator}
\alias{jump.locator}
\title{Removing artefacts due to manual adjustments of dendrometers automatically for more than one dendrometers}
\usage{
jump.locator(df, v)
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS} and the dendrometer data in following columns.}

\item{v}{numerical value which is considered as artefact. E.g. \code{v}=1 implies that if the difference to the consecutive data point is more than 1 or less than -1, it will be considered as an artefact.}
}
\value{
A dataframe containing jump-free dendrometer data.
}
\description{
Dendrometers generally have limited memory capacity beyond which it stops recording. To keep the measurement ongoing, they should be adjusted periodically, which can cause positive or negative jumps in the data. This function locates these artefacts and adjusts them.Unlike in \code{\link[dendRoAnalyst:i.jump.locator]{i.jump.locator}}, it can handle dataset with more than one dendrometers.
}
\examples{
library(dendRoAnalyst)
data(nepa)
jump_free_nepa<-jump.locator(df=nepa ,v=1)
head(jump_free_nepa,10)

}
