% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i.jump.locator.R
\name{i.jump.locator}
\alias{i.jump.locator}
\title{Removing artefacts due to manual adjustments of dendrometers interactively}
\usage{
i.jump.locator(df, TreeNum, v)
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS} and the dendrometer data in following columns.}

\item{TreeNum}{numerical value indicating the tree to be analysed. E.g. '1' refers to the first dendrometer data column in \emph{df}.}

\item{v}{numerical value which is considered as artefact. E.g. \code{v}=1 implies that if the difference to the consecutive data point is more than 1 or less than -1, it will be considered as an artefact.}
}
\value{
A dataframe containing jump-free dendrometer data.
}
\description{
Dendrometers generally have limited memory capacity beyond which it stops recording. To keep the measurement ongoing, they should be adjusted periodically, which can cause positive or negative jumps in the data. This function locates these artefacts and interactively adjusts them one by one.
}
\examples{
library(dendRoAnalyst)
data(nepa)
jump_free_nepa<-i.jump.locator(df=nepa, TreeNum=1 ,v=1)
head(jump_free_nepa,10)

}
