% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_dna.R
\name{clean_dna}
\alias{clean_dna}
\title{Removes Gaps, Ambiguities and Missing Data from DNA Sequences}
\usage{
clean_dna(dna, verbose = TRUE)
}
\arguments{
\item{dna}{an object of class \link[ape:DNAbin]{DNAbin}.}

\item{verbose}{logical. Returns a warning if any sequence contains non ACTG bases.}
}
\value{
an object of class \link[ape:DNAbin]{DNAbin}.
}
\description{
\code{clean_dna()} removes all character not a valid ACTG base from a \link[ape:DNAbin]{DNAbin}
object.
}
\details{
\code{clean_dna()} detects and removes any non ACTG bases from alignment. This includes:
"N", "-", "?", "R", "Y", etc. If \code{verbose = TRUE}, returns a warning if these characters
are inside the sequences, i.e, are not alignment padding chars at the ends.
}
\examples{
geo_clean <- clean_dna(geophagus)

}
\author{
Rupert A. Collins
}
