% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submission.R
\name{as.labeled.data.frame}
\alias{as.labeled.data.frame}
\title{Coerce data.frame to labeled.}
\usage{
\method{as.labeled}{data.frame}(x, label, spec, check = TRUE, ...)
}
\arguments{
\item{x}{data.frame}

\item{label}{a SAS-style label for x}

\item{spec}{a spec (specification) data.frame containing column labels}

\item{check}{should the data.frame be required to match its specification?}

\item{...}{ignored}
}
\description{
Coerces data.frame to labeled.
}
\details{
Positive numeric values less than 1e-70 are coerced to zero to solve SAS encoding issues.
Column names are forced unique and forced SAS-compliant with \code{link{makesasnames}}.
Labels are added to the data.frame column names, and to the data.frame itself.
}
\seealso{
\code{\link{as.labeled.character}}
}
