% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect2.R
\name{detect2}
\alias{detect2}
\title{Language detection using DeepL API Free}
\usage{
detect2(text, auth_key = "your_key")
}
\arguments{
\item{text}{character vector with texts to classify. Only UTF8-encoded plain text is supported.
An element can contain several sentences, but should not exceed 30kbytes.}

\item{auth_key}{Authentication key.}
}
\description{
\code{detect2} guesses the language of a text using DeepL API Free.
    Use \code{available_languages} to list all supported languages. An authentication key
    is required to use this service. With the DeepL API Free package, developers can translate
    up to 500,000 characters per month for free.
}
\details{
To get an authentication key, you need to register for a DeepL API Free
    account (\url{https://www.deepl.com/pro#developer}).
}
\examples{
\dontrun{
detect2("My name is Hans.", auth_key = "my_key")
}

}
\references{
\href{https://www.deepl.com/pro#developer}{DeepL API documentations}
}
