% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepdep.R
\name{deepdep}
\alias{deepdep}
\title{Acquire the dependencies of the package on any depth level}
\usage{
deepdep(
  package,
  depth = 1,
  downloads = FALSE,
  bioc = FALSE,
  local = FALSE,
  dependency_type = c("Depends", "Imports")
)
}
\arguments{
\item{package}{A \code{character}. Name of the package that is on CRAN, Bioconductor repository or locally installed.
See \code{bioc} and \code{local} arguments.}

\item{depth}{An \code{integer}. Maximum depth level of the dependency. By default it's \code{1}.}

\item{downloads}{A \code{logical}. If \code{TRUE} add dependency downloads data. By default it's \code{FALSE}.}

\item{bioc}{A \code{logical} value. If \code{TRUE} the Bioconductor dependencies data will be taken from the
Bioconductor repository. For this option to work properly, \code{BiocManager} package needs to be installed.}

\item{local}{A \code{logical} value. If \code{TRUE} only data of locally installed packages will be used (without API usage).}

\item{dependency_type}{A \code{character} vector. Types of the dependencies that should be sought.
Possibilities are: \code{"Imports", "Depends", "Suggests", "Enhances", "LinkingTo"}. By default it's \code{"Depends", "Imports"}.}
}
\value{
An object of \code{deepdep} class.
}
\description{
This function is an ultimate wrapper for \code{\link{get_dependencies}}. It inherits all of the arguments and
allows to recursively search for the dependencies at the higher level of \code{depth}.
}
\examples{

\donttest{
library(deepdep)

dd_downloads <- deepdep("ggplot2")
head(dd_downloads)

dd_2 <- deepdep("ggplot2", depth = 2, downloads = TRUE)
plot_dependencies(dd_2, "circular")

dd_local <- deepdep("deepdep", local = TRUE)
plot_dependencies(dd_local)
}


}
\seealso{
\code{\link{get_dependencies}}
}
