% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_deepdep.R
\name{plot_dependencies}
\alias{plot_dependencies}
\alias{plot_dependencies.default}
\alias{plot_dependencies.character}
\alias{plot_dependencies.deepdep}
\title{Main plot function for a \code{deepdep} object}
\usage{
plot_dependencies(
  x,
  type = "circular",
  same_level = FALSE,
  reverse = FALSE,
  label_percentage = 1,
  show_version = FALSE,
  show_downloads = FALSE,
  ...
)

\method{plot_dependencies}{default}(
  x,
  type = "circular",
  same_level = FALSE,
  reverse = FALSE,
  label_percentage = 1,
  show_version = FALSE,
  show_downloads = FALSE,
  ...
)

\method{plot_dependencies}{character}(
  x,
  type = "circular",
  same_level = FALSE,
  reverse = FALSE,
  label_percentage = 1,
  show_version = FALSE,
  show_downloads = FALSE,
  ...
)

\method{plot_dependencies}{deepdep}(
  x,
  type = "circular",
  same_level = FALSE,
  reverse = FALSE,
  label_percentage = 1,
  show_version = FALSE,
  show_downloads = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{deepdep}} object or a \code{character} package name.}

\item{type}{A \code{character}. Possible values are \code{circular} and \code{tree}.}

\item{same_level}{A \code{logical}. If \code{TRUE} links between dependencies on the same
level will be added. By default it's \code{FALSE}.}

\item{reverse}{A \code{logical}. If \code{TRUE} links between dependencies pointing from
deeper level to more shallow level will be added. By default it's \code{FALSE}.}

\item{label_percentage}{A \code{numeric} value between \code{0} and \code{1}. A fraction
of labels to be displayed. By default it's \code{1} (all labels displayed).}

\item{show_version}{A \code{logical}. If \code{TRUE} required version of package will be
displayed below package name. Defaults to \code{FALSE}.}

\item{show_downloads}{A \code{logical}. If \code{TRUE} total number of downloads of packages
will be displayed below package names. Defaults to \code{FALSE}.}

\item{...}{Other arguments passed to the \code{deepdep} function.}
}
\value{
A \code{ggplot2, gg, ggraph, deepdep_plot} class object.
}
\description{
Visualize dependency data from a \code{deepdep} object using
\code{ggplot2} and \code{ggraph} packages. Several tree-like layouts are available.
}
\examples{

\donttest{
library(deepdep)

#:# use local packages
plot_dependencies("deepdep", depth = 2, local = TRUE)

dd <- deepdep("ggplot2")
plot_dependencies(dd, "tree")

dd2 <- deepdep("ggplot2", depth = 2)
plot_dependencies(dd2, "circular")

#:# show grand_total download count
plot_dependencies("shiny", show_downloads = TRUE)
}

}
