% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_available_packages.R
\name{get_available_packages}
\alias{get_available_packages}
\title{Get the list of available packages}
\usage{
get_available_packages(bioc = FALSE, local = FALSE, reset_cache = FALSE)
}
\arguments{
\item{bioc}{A \code{logical} value. If \code{TRUE} the Bioconductor dependencies data will be taken from the
Bioconductor repository. For this option to work properly, \code{BiocManager} package needs to be installed.}

\item{local}{A \code{logical} value. If \code{TRUE} only data of locally installed packages will be used (without API usage).}

\item{reset_cache}{A \code{logical} value. If \code{TRUE} the cache will be cleared before obtaining the list of packages.}
}
\value{
A \code{character} vector.
}
\description{
Get names of packages that you have locally installed or that are available to be installed.
}
\details{
Function uses caching - only the first usage scraps information from servers. Those
objects are then saved locally in temporary file and further usages loads needed data from the file.

Arguments \code{bioc} and \code{local} cannot be \code{TRUE} simultaneously.
If neither \code{local} nor \code{bioc} are \code{TRUE}, vector contains all packages available
currently on CRAN. If \code{bioc} is \code{TRUE}, vector contains all packages available currently
on CRAN and via Bioconductor. If \code{local} is \code{TRUE}, vactor contains all of the packages
that are currently installed.
}
\examples{
library(deepdep)

av <- get_available_packages()
head(av)

}
