% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data.R
\name{sample_data}
\alias{sample_data}
\alias{sample_data_dir}
\alias{sample_data_file}
\alias{sample_plate}
\alias{sample_results_file}
\title{Get sample data}
\usage{
sample_data_dir(size = c("small", "large"))

sample_data_file()

sample_results_file()

sample_plate(size = c("small", "large"))
}
\arguments{
\item{size}{The dataset to retrieve, either \code{"small"} or \code{"large"}}
}
\description{
These functions return sample data files or folders and can be used to
load ddPCR plates with sample data. They are used primarily in the
documentation examples, but you can also use them for learning purposes.
There are two sample datasetes: a small dataset and a large dataset. The
small dataset contains the full raw data, but the large dataset only
includes the processed data because the raw data would be too large.
\cr\cr
\code{sample_data_dir}: get the directory of the small or large sample dataset\cr
\code{sample_data_file}: get path to one of the data files in the small sample dataset\cr
\code{sample_results_file}: get path to the results file of the small sample dataset\cr
\code{sample_plate}: get the ddpcr plate object containing the data of the small or large dataset\cr
}
\examples{
plate1 <- new_plate(dir = sample_data_dir())
plate2 <- new_plate(data_files = sample_data_file(), meta_file = sample_results_file())
plate3 <- sample_plate()
}

