% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddml_pliv.R
\name{ddml_pliv}
\alias{ddml_pliv}
\title{Estimator for the Partially Linear IV Model.}
\usage{
ddml_pliv(
  y,
  D,
  Z,
  X,
  learners,
  learners_DX = learners,
  learners_ZX = learners,
  sample_folds = 2,
  ensemble_type = "nnls",
  shortstack = FALSE,
  cv_folds = 5,
  subsamples = NULL,
  cv_subsamples_list = NULL,
  silent = FALSE
)
}
\arguments{
\item{y}{The outcome variable.}

\item{D}{A matrix of endogenous variables.}

\item{Z}{A matrix of instruments.}

\item{X}{A (sparse) matrix of control variables.}

\item{learners}{May take one of two forms, depending on whether a single
learner or stacking with multiple learners is used for estimation of the
conditional expectation functions.
If a single learner is used, \code{learners} is a list with two named
elements:
\itemize{
\item{\code{what} The base learner function. The function must be
such that it predicts a named input \code{y} using a named input
\code{X}.}
\item{\code{args} Optional arguments to be passed to \code{what}.}
}
If stacking with multiple learners is used, \code{learners} is a list of
lists, each containing four named elements:
\itemize{
\item{\code{fun} The base learner function. The function must be
such that it predicts a named input \code{y} using a named input
\code{X}.}
\item{\code{args} Optional arguments to be passed to \code{fun}.}
\item{\code{assign_X} An optional vector of column indices
corresponding to control variables in \code{X} that are passed to
the base learner.}
\item{\code{assign_Z} An optional vector of column indices
corresponding to instruments in \code{Z} that are passed to the
base learner.}
}
Omission of the \code{args} element results in default arguments being
used in \code{fun}. Omission of \code{assign_X} (and/or \code{assign_Z})
results in inclusion of all variables in \code{X} (and/or \code{Z}).}

\item{learners_DX}{Optional argument to allow for different estimators of
\eqn{E[D|X]}. Setup is identical to \code{learners}.}

\item{learners_ZX}{Optional argument to allow for different estimators of
\eqn{E[Z\vert X]}. Setup is identical to \code{learners}.}

\item{sample_folds}{Number of cross-fitting folds.}

\item{ensemble_type}{Ensemble method to combine base learners into final
estimate of the conditional expectation functions. Possible values are:
\itemize{
\item{\code{"nnls"} Non-negative least squares.}
\item{\code{"nnls1"} Non-negative least squares with the constraint
that all weights sum to one.}
\item{\code{"singlebest"} Select base learner with minimum MSPE.}
\item{\code{"ols"} Ordinary least squares.}
\item{\code{"average"} Simple average over base learners.}
}
Multiple ensemble types may be passed as a vector of strings.}

\item{shortstack}{Boolean to use short-stacking.}

\item{cv_folds}{Number of folds used for cross-validation in ensemble
construction.}

\item{subsamples}{List of vectors with sample indices for cross-fitting.}

\item{cv_subsamples_list}{List of lists, each corresponding to a subsample
containing vectors with subsample indices for cross-validation.}

\item{silent}{Boolean to silence estimation updates.}
}
\value{
\code{ddml_pliv} returns an object of S3 class
\code{ddml_pliv}. An object of class \code{ddml_pliv} is a list
containing the following components:
\describe{
\item{\code{coef}}{A vector with the \eqn{\theta_0} estimates.}
\item{\code{weights}}{A list of matrices, providing the weight
assigned to each base learner (in chronological order) by the
ensemble procedure.}
\item{\code{mspe}}{A list of matrices, providing the MSPE of each
base learner (in chronological order) computed by the
cross-validation step in the ensemble construction.}
\item{\code{iv_fit}}{Object of class \code{ivreg} from the IV
regression of \eqn{Y - \hat{E}[Y\vert X]} on
\eqn{D - \hat{E}[D\vert X]} using \eqn{Z - \hat{E}[Z\vert X]} as
the instrument. See also \code{\link[AER:ivreg]{AER::ivreg()}} for details.}
\item{\code{learners},\code{learners_DX},\code{learners_ZX},
\code{subsamples},\code{cv_subsamples_list},\code{ensemble_type}
}{Pass-through of selected user-provided arguments. See above.}
}
}
\description{
Estimator for the partially linear IV model.
}
\details{
\code{ddml_pliv} provides a double/debiased machine learning
estimator for the parameter of interest \eqn{\theta_0} in the partially
linear IV model given by

\eqn{Y = \theta_0D + g_0(X) + U,}

where \eqn{(Y, D, X, Z, U)} is a random vector such that
\eqn{E[Cov(U, Z\vert X)] = 0} and \eqn{E[Cov(D, Z\vert X)] \neq 0}, and
\eqn{g_0} is an unknown nuisance function.
}
\examples{
# Construct variables from the included Angrist & Evans (1998) data
y = AE98[, "worked"]
D = AE98[, "morekids"]
Z = AE98[, "samesex"]
X = AE98[, c("age","agefst","black","hisp","othrace","educ")]

# Estimate the partially linear IV model using a single base learner, ridge.
pliv_fit <- ddml_pliv(y, D, Z, X,
                      learners = list(what = mdl_glmnet,
                                      args = list(alpha = 0)),
                      sample_folds = 2,
                      silent = TRUE)
summary(pliv_fit)
}
\references{
Ahrens A, Hansen C B, Schaffer M E, Wiemann T (2023). "ddml: Double/debiased
machine learning in Stata." \url{https://arxiv.org/abs/2301.09397}

Chernozhukov V, Chetverikov D, Demirer M, Duflo E, Hansen C B, Newey W,
Robins J (2018). "Double/debiased machine learning for treatment and
structural parameters." The Econometrics Journal, 21(1), C1-C68.

Kleiber C, Zeileis A (2008). Applied Econometrics with R. Springer-Verlag,
New York.

Wolpert D H (1992). "Stacked generalization." Neural Networks, 5(2), 241-259.
}
\seealso{
\code{\link[=summary.ddml_pliv]{summary.ddml_pliv()}}, \code{\link[AER:ivreg]{AER::ivreg()}}

Other ddml: 
\code{\link{ddml_ate}()},
\code{\link{ddml_fpliv}()},
\code{\link{ddml_late}()},
\code{\link{ddml_plm}()}
}
\concept{ddml}
