% Generated by roxygen2 (4.0.1): do not edit by hand
\name{iterate}
\alias{iterate}
\title{Perform one iteration of MCMC procedure}
\usage{
iterate(nattributes, class0, estimates0, threshold.labels, lambda.equations,
  is.pi.r, parameter.means, parameter.acov, observations, nobservations,
  is.parameter.randomized, qmatrix, pmatrix)
}
\arguments{
\item{nattributes}{numberic value for number of attributes}

\item{class0}{The previous value of attribute profile for each respondent}

\item{estimates0}{a numeric vector of parameter estimates}

\item{threshold.labels}{an nclasses by nitems character matrix with appropriate threshold labels}

\item{lambda.equations}{equations for lambda parameters}

\item{is.pi.r}{If \code{FALSE} (the default), parameter values are the type of \code{taus} and \code{nus} or
\code{lambdas} and \code{gammas} else they are the type \code{pis} and \code{rs} as used in NC-RUM parameterization}

\item{parameter.means}{a numerical vector of calibrated item and structural parameters}

\item{parameter.acov}{a numerical matrix of covariances of item and structural parameters}

\item{observations}{a data frame or matrix of dichotomous responses}

\item{nobservations}{a numeric value of number of observations}

\item{is.parameter.randomized}{if true parameter estimates are randomized using acov matrix}

\item{qmatrix}{a data frame or matrix of 1s and 0s indicating relation between items and attributes.
This matrix specifies which items are required for mastery of each attribute (i.e., latent variable).
A matrix must be a size of \code{nItems X nAttributes}}

\item{pmatrix}{a numeric nclasses by nattributes matrix of all possible attribute profiles}
}
\value{
a list of newly sampled classes and parameter estimates
}
\description{
If applicable, randomly samples new set of parameter estimates, obtains applicable estimates
and uses those to calculate threshold values for both items and latent variables, draws
new set of alpha values.
}

