% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{person}
\alias{person}
\title{Person data, income and smoking habits}
\format{
A data frame with x rows and variables:
\describe{
\item{income}{monthly income, in US dollars}
\item{age}{age of a person in year}
\item{gender}{gender of a person}
\item{year}{year of measurement}
\item{smokes}{if a person smokes or not}
\item{cigarettes}{how many cigarretes a person smokes}
...
}
The dataset is also available as a sqlite database at
\code{system.file("db/person.db", package="dcmodifydb")}
}
\usage{
person
}
\description{
A synthetic data set with person data with records to be corrected.
The datasethas missing values
}
\examples{

# load modification rules and apply:
library(dcmodify)
rules <- modifier(.file = system.file("db/corrections.yml", package="dcmodifydb"))

con <- DBI::dbConnect(RSQLite::SQLite(), dbname=system.file("db/person.db", package="dcmodifydb"))
person <- dplyr::tbl(con, "person")
print(person)

person2 <- modify(person, rules, copy=TRUE)
print(person2)
}
\keyword{datasets}
