% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRel}
\alias{plotRel}
\title{Plot Relatedness Estimates}
\usage{
plotRel(
  r,
  rlim = c(0, 1),
  isig = NULL,
  alpha = NULL,
  col = grDevices::hcl.colors(101, "YlGnBu", rev = TRUE),
  draw_diag = FALSE,
  col_diag = "gray",
  border_diag = NA,
  lwd_diag = 0.5,
  border_sig = "orangered2",
  lwd_sig = 1.5,
  xlab = "",
  ylab = "",
  add = FALSE,
  idlab = FALSE,
  side_id = c(1, 2),
  col_id = 1,
  cex_id = 0.5,
  srt_id = NULL,
  ...
)
}
\arguments{
\item{r}{a matrix or a 3-dimensional array as returned by
\code{\link{ibdDat}}.}

\item{rlim}{the range of values for colors. If \code{NULL} or \code{NA}, will
be calculated from \code{r}.}

\item{isig}{a matrix with two columns providing indices of relatedness matrix
entries to be outlined ("significant" sample pairs). Takes precedence over
\code{alpha}.}

\item{alpha}{significance level for hypothesis testing; determines
relatedness matrix entries to be outlined. Ignored if \code{isig} is not
\code{NULL}.}

\item{col}{the colors for the range of relatedness values.}

\item{draw_diag}{a logical value specifying if diagonal cells should be
distinguished from others by a separate color.}

\item{col_diag, border_diag, lwd_diag}{the color for the fill, the color for
the border, and the line width for the border of diagonal entries. Ignored
if \code{draw_diag = FALSE}.}

\item{border_sig, lwd_sig}{the color and the line width for outlining entries
specified by \code{isig} or \code{alpha}.}

\item{xlab, ylab}{axis labels.}

\item{add}{a logical value specifying if the graphics should be added to the
existing plot (useful for triangular matrices).}

\item{idlab}{a logical value specifying if sample ID's should be displayed.}

\item{side_id}{an integer vector specifying plot sides for sample ID labels.}

\item{col_id, cex_id}{numeric vectors for the color and the size of sample ID
labels.}

\item{srt_id}{a vector of the same length as \code{side_id} specifying
rotation angles for sample ID labels. If \code{NULL}, the labels will be
perpendicular to the axes.}

\item{...}{other graphical parameters.}
}
\value{
\code{NULL}; called for plotting.
}
\description{
Represents a matrix of pairwise relatedness estimates with colors
corresponding to the levels of relatedness. Optionally, also outlines results
of a hypothesis testing. The plot follows a matrix layout.
}
\examples{
parstart <- par(no.readonly = TRUE)   # save starting graphical parameters

par(mar = c(1, 2, 2, 1))
plotRel(dres, alpha = 0.05, draw_diag = TRUE)

# draw log of p-values in the upper triangle
pmat <- matrix(NA, nrow(dres), ncol(dres))
pmat[upper.tri(pmat)] <- t(log(dres[, , "p_value"]))[upper.tri(pmat)]
pmat[pmat == -Inf] <- min(pmat[is.finite(pmat)])
plotRel(pmat, rlim = NULL, draw_diag = TRUE, col = hcl.colors(101, "PuRd"),
        add = TRUE, col_diag = "slategray2", border_diag = 1)

# symmetric matrix, outline significant in upper triangle, display sample ID
par(mar = c(3, 3, 1, 1))
dmat <- dres[, , "estimate"]
dmat[upper.tri(dmat)] <- t(dmat)[upper.tri(t(dmat))]
isig <- which(dres[, , "p_value"] <= 0.05, arr.ind = TRUE)
col_id <- rep(c("plum4", "lightblue4"), each = 26)
plotRel(dmat, isig = isig[, 2:1], draw_diag = TRUE, idlab = TRUE,
        col_id = col_id)
abline(v = 26, h = 26, col = "gray45", lty = 5)

# rotated sample ID labels on all sides
par(mar = c(3, 3, 3, 3))
plotRel(dmat, isig = rbind(isig, isig[, 2:1]), border_sig = "magenta2",
        draw_diag = TRUE, idlab = TRUE, side_id = 1:4, col_id = col_id,
        srt_id = c(-55, 25, 65, -35))
par(parstart)

}
\seealso{
\code{\link{plotColorbar}} for a colorbar.
}
