% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-values.R
\name{valid_annotation_values}
\alias{valid_annotation_values}
\alias{valid_annotation_values.NULL}
\alias{valid_annotation_values.synapseclient.entity.File}
\alias{valid_annotation_values.data.frame}
\alias{valid_annotation_values.synapseclient.table.CsvFileTable}
\title{Valid annotation values}
\usage{
valid_annotation_values(x, annotations, ...)

\method{valid_annotation_values}{`NULL`}(x, annotations, ...)

\method{valid_annotation_values}{synapseclient.entity.File}(x, annotations, syn, ...)

\method{valid_annotation_values}{data.frame}(x, annotations, ...)

\method{valid_annotation_values}{synapseclient.table.CsvFileTable}(x, annotations, ...)
}
\arguments{
\item{x}{An object to check.}

\item{annotations}{A data frame of annotation definitions. Must contain at
least three columns: \code{key}, \code{value}, and \code{columnType}.}

\item{...}{Additional options to \code{\link[=check_values]{check_values()}}}

\item{syn}{Synapse client object}
}
\value{
A named list of valid annotation values.
}
\description{
Checks for and returns the valid annotation valaues in a data frame, Synapse
file, or Synapse file view.
}
\section{Methods (by class)}{
\itemize{
\item \code{NULL}: Return NULL

\item \code{synapseclient.entity.File}: Valid annotation values on a Synapse file

\item \code{data.frame}: Valid annotation values in a data frame

\item \code{synapseclient.table.CsvFileTable}: Valid annotation values in a Synapse table
}}

\examples{
annots <- data.frame(
  key = c("assay", "fileFormat", "fileFormat", "fileFormat", "species"),
  value = c("rnaSeq", "fastq", "txt", "csv", "Human"),
  columnType = c("STRING", "STRING", "STRING", "STRING", "STRING")
)
dat1 <- data.frame(assay = "not a valid assay")
dat2 <- data.frame(assay = "rnaSeq")
valid_annotation_values(dat1, annots)
valid_annotation_values(dat2, annots)
}
