% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_field_check.R
\name{pkg_field_check}
\alias{pkg_field_check}
\title{Package Required Field Check}
\usage{
pkg_field_check(DD.dict, DS.data, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as a list of the fields not found in the data dictionary.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (Named vector of TRUE/FALSE values alerting user if checks passed (TRUE) or failed (FALSE) for \code{TYPE}, \code{MIN}, and \code{MAX}).
}
\description{
This function checks for additional fields required by this package including variable type (\code{TYPE}), minimum value (\code{MIN}), and maximum value (\code{MAX}).
}
\details{
Even though MIN, MAX, and TYPE are not required by dbGaP, our package was created to use these variables in a series of other checks and awareness functions (e.g., render_report, values_check, etc.). If this function fails, the add_missing_fields function can be used.
}
\examples{
# Example 1: Fail check
data(ExampleD)
pkg_field_check(DD.dict.D, DS.data.D)
# Use the add_missing_fields function to add in data
DD.dict.updated <- add_missing_fields(DD.dict.D, DS.data.D)
# Be sure to call in the new version of the dictionary (DD.dict.updated)
pkg_field_check(DD.dict.updated, DS.data.D) 

# Example 2: Pass check
data(ExampleA)
pkg_field_check(DD.dict.A, DS.data.A)
print(pkg_field_check(DD.dict.A, DS.data.A, verbose=FALSE))
}
\seealso{
\code{\link{add_missing_fields}}
}
