% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/browse.R
\name{browse}
\alias{browse}
\title{Browse the contents of a nested data structure}
\usage{
browse(x = .GlobalEnv, name)
}
\arguments{
\item{x}{Object.}

\item{name}{Name of the object.}
}
\value{
Nothing.
}
\description{
Manually step in and out of the elements of complex data structure with
\code{\link{whos}}. To move around enter the name or number of the element
you want to inspect next. Partial names will automatically be matched against
the possible element names.
}
\examples{
\dontrun{
require(ggplot2)
p <- ggplot(iris, aes(x=Sepal.Length, y=Sepal.Width)) +
    geom_point()
browse(p)
}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
whos
}

