% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_filesize}
\alias{get_filesize}
\title{Get File size of file}
\usage{
get_filesize(
  x,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER")
)
}
\arguments{
\item{x}{A numeric fileid or file-specific DOI}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \verb{DATAVERSE_SERVER = "dataverse.harvard.edu} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}
}
\value{
number of bytes as a numeric
}
\description{
Get File size of file
}
\keyword{internal}
