% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetDatetimeModelObject}
\alias{GetDatetimeModelObject}
\title{Retrieve the details of a specified datetime model.}
\usage{
GetDatetimeModelObject(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Unique alphanumeric identifier for the model of interest.}
}
\value{
An S3 object of class `dataRobotDatetimeModel', which is a list
with the following components:
\itemize{
  \item featurelistId. Character string: unique alphanumeric identifier for the featurelist on
    which the model is based.
  \item processes. Character vector with components describing preprocessing; may include
    modelType.
  \item featurelistName. Character string giving the name of the featurelist on which the model
    is based.
  \item projectId. Character string giving the unique alphanumeric identifier for the project.
  \item samplePct. Numeric: percentage of the dataset used to form the training dataset for
    model fitting.
  \item isFrozen. Logical : is model created with frozen tuning parameters.
  \item modelType. Character string describing the model type.
  \item metrics. List with one element for each valid metric associated with the model.
    Each element is a list with elements for each possible evaluation type (holdout, validation,
    and crossValidation).
  \item modelCategory. Character string giving model category (e.g., blend, model).
  \item blueprintId. Character string giving the unique DataRobot blueprint identifier on which
    the model is based.
  \item modelId. Character string giving the unique alphanumeric model identifier.
  \item projectName. Character string: optional description of project defined by projectId.
  \item projectTarget. Character string defining the target variable predicted by all models in
    the project.
  \item projectMetric. Character string defining the fitting metric optimized by all project
    models.
  \item trainingRowCount. Integer. The number of rows of the project dataset used in training
    the model. In a datetime partitioned project, if specified, defines the number of
     rows used to train the model and evaluate backtest scores; if unspecified, either
     \code{trainingDuration} or \code{trainingStartDate} and \code{trainingEndDate} was used to
     determine that instead.
  \item trainingDuration. Character string or none only present for models in datetime
    partitioned projects. If specified, a duration string specifying the duration spanned by the
    data used to train the model and evaluate backtest scores.
  \item trainingStartDate. Charcter string or none only present for frozen models in datetime
    partitioned projects. If specified, the start date of the data used to train the model.
  \item trainingEndDate. Charcter string or none only present for frozen models in datetime
    partitioned projects. If specified, the end date of the data used to train the model.
  \item backtests. list describes what data was used to fit each backtest, the score for the
    project metric, and why the backtest score is unavailable if it is not provided.
  \item dataSelectionMethod. Character string which of trainingRowCount, trainingDuration,
    or trainingStartDate and trainingEndDate were used to determine the data used to fit the
    model. One of 'rowCount', 'duration', or 'selectedDateRange'.
  \item trainingInfo. list describes which data was used to train on when scoring the holdout and
    making predictions.
  trainingInfo will have the following keys: `holdoutTrainingStartDate`,
    `holdoutTrainingDuration`, `holdoutTrainingRowCount`, `holdoutTrainingEndDate`,
    `predictionTrainingStartDate`, `predictionTrainingDuration`,
    `predictionTrainingRowCount`, `predictionTrainingEndDate`.  Start and end dates will be
    datetime string, durations will be duration strings, and rows will be integers.
  \item holdoutScore. numeric or none the score against the holdout, if available and the holdout
    is unlocked, according to the project metric.
  \item holdoutStatus. Character string the status of the holdout score, e.g. "COMPLETED",
    "HOLDOUT_BOUNDARIES_EXCEEDED".
}
}
\description{
This function returns a DataRobot S3 object of class
dataRobotDatetimeModel for the model defined by project and modelId.
}
\details{
If the project does not use datetime partitioning an error will occur.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  GetDatetimeModelObject(projectId, modelId)
}
}
