% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiftChart.R
\name{ListLiftCharts}
\alias{ListLiftCharts}
\title{Retrieve lift chart data for a model for all available data partitions (see DataPartition)}
\usage{
ListLiftCharts(model, fallbackToParentInsights = FALSE)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object like that returned by \code{GetModel}.}

\item{fallbackToParentInsights}{logical. If TRUE, this will return the lift chart data for the
model's parent if the lift chart is not available for the model and the model has a parent
model.}
}
\value{
data.frame with the following components:
\itemize{
  \item binWeight. Numeric: weight of the bin.  For weighted projects, the sum of the weights of
    all rows in the bin; otherwise, the number of rows in the bin.
  \item actual. Numeric: sum of actual target values in bin.
  \item predicted. Numeric: sum of predicted target values in bin.
}
}
\description{
Retrieve lift chart data for a model for all available data partitions (see DataPartition)
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  ListLiftCharts(model)
}
}
