% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Validate.R
\name{IsParameterIn}
\alias{IsParameterIn}
\title{Check if a parameter is in a list of possibilities.}
\usage{
IsParameterIn(
  paramValue,
  paramPossibilities,
  allowNULL = TRUE,
  paramName = NULL
)
}
\arguments{
\item{paramValue}{object. The parameter value to check.}

\item{paramPossibilities}{vector. A vector of possible values for the parameter.}

\item{allowNULL}{logical. Whether or not to allow NULL as a possibility.}

\item{paramName}{character. The name of the parameter to check.}
}
\value{
TRUE if \code{paramValue} is valid, otherwise returns an error message.
}
\description{
Check if a parameter is in a list of possibilities.
}
\examples{
\dontrun{
  IsParameterIn("all", DataSubset)
}
}
