% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_histogram.R
\name{util_histogram}
\alias{util_histogram}
\title{Utility function to create histograms}
\usage{
util_histogram(
  plot_data,
  num_var = colnames(plot_data)[1],
  fill_var = NULL,
  facet_var = NULL,
  nbins_max = 100,
  colors = "#2166AC",
  is_datetime = FALSE
)
}
\arguments{
\item{plot_data}{a \code{data.frame} without missing values}

\item{num_var}{column name of the numerical or datetime variable
in \code{plot_data} (if omitted, the first column is assumed to
contain this variable)}

\item{fill_var}{column name of the categorical variable in \code{plot_data} which
will be used for coloring stacked histograms}

\item{facet_var}{column name of the categorical variable in \code{plot_data}
which will be used to create facets}

\item{nbins_max}{the maximum number of bins for the histogram (see
\code{util_optimize_histogram_bins})}

\item{colors}{vector of colors, or a single color}

\item{is_datetime}{if \code{TRUE}, the x-axis will be adapted for the
datetime format}
}
\value{
a histogram
}
\description{
A helper function for simple histograms.
}
