% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_conversion_stable.R
\name{util_conversion_stable}
\alias{util_conversion_stable}
\title{Can a vector be converted to  a defined \code{DATA_TYPE}}
\usage{
util_conversion_stable(vector, data_type, return_percentages = FALSE)
}
\arguments{
\item{vector}{\link{vector} input vector,}

\item{data_type}{\link{enum} The type, to what the conversion should be tried.}

\item{return_percentages}{\link{logical} return the percentage of stable
conversions or matches.}
}
\value{
\link{numeric} ratio of convertible entries in \code{vector}
}
\description{
the function also checks, if the conversion is perfect, or if something
is lost (e.g., decimal places), or something is strange (like arbitrary
suffixes in a date, just note, that
\code{as.POSIXct("2020-01-01 12:00:00 CET asdf")} does not fail in \code{R}), but
\code{util_conversion_stable("2020-01-01 12:00:00 CET asdf", DATA_TYPES$DATETIME)}
will.
}
\details{
\emph{HINT:}
\code{util_conversion_stable(.Machine$integer.max + 1, DATA_TYPES$INTEGER)} seems
to work correctly, although \code{is.integer(.Machine$integer.max + 1)}
returns \code{FALSE}.
}
\keyword{internal}
