% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_study_var2factor.R
\name{util_study_var2factor}
\alias{util_study_var2factor}
\title{Convert a study variable to a \link{factor}}
\usage{
util_study_var2factor(
  resp_vars = NULL,
  study_data,
  meta_data = "item_level",
  label_col = LABEL,
  assume_consistent_codes = TRUE,
  have_cause_label_df = FALSE,
  code_name = c(JUMP_LIST, MISSING_LIST),
  include_sysmiss = TRUE
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{assume_consistent_codes}{\link{logical} assume, that missing codes are
consistent for all variables}

\item{have_cause_label_df}{\link{logical} is a missing-code table available}

\item{code_name}{\link{character} all lists from the \link{meta_data} to use for the
coding.}

\item{include_sysmiss}{\link{logical} add also a factor level for data values
that were \code{NA} in the original study data
(system missingness).}
}
\value{
\code{study_data} converted to factors using the coding provided in
\code{code_name}
}
\description{
Convert a study variable to a \link{factor}
}
\seealso{
Other data_management: 
\code{\link{util_assign_levlabs}()},
\code{\link{util_check_data_type}()},
\code{\link{util_check_group_levels}()},
\code{\link{util_compare_meta_with_study}()},
\code{\link{util_dichotomize}()},
\code{\link{util_merge_data_frame_list}()},
\code{\link{util_rbind}()},
\code{\link{util_remove_na_records}()},
\code{\link{util_replace_hard_limit_violations}()},
\code{\link{util_table_of_vct}()}
}
\concept{data_management}
\concept{metadata_management}
\keyword{internal}
