% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_end_digits.R
\name{acc_end_digits}
\alias{acc_end_digits}
\title{Extension of \link{acc_shape_or_scale} to examine uniform distributions of
end digits}
\usage{
acc_end_digits(resp_vars = NULL, study_data, meta_data, label_col = VAR_NAMES)
}
\arguments{
\item{resp_vars}{\link{variable} the names of the measurement variables,
mandatory}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}
}
\value{
a \link{list} with:
\itemize{
\item \code{SummaryData}: data frame underlying the plot
\item \code{SummaryPlot}: ggplot2 distribution plot comparing expected
with observed distribution
}
}
\description{
This implementation contrasts the empirical distribution of a measurement
variables against assumed distributions. The approach is adapted from the
idea of rootograms (Tukey (1977)) which is also applicable for count data
(Kleiber and Zeileis (2016)).
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item This implementation is restricted to data of type float or integer.
\item Missing codes are removed from resp_vars (if defined in the metadata)
\item The user must specify the column of the metadata containing probability
distribution (currently only: normal, uniform, gamma)
\item Parameters of each distribution can be estimated from the data or are
specified by the user
\item A histogram-like plot contrasts the empirical vs. the technical
distribution
}
}

\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_end_digits.html}{Online Documentation}
}
