% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_report_by.R
\name{dq_report_by}
\alias{dq_report_by}
\title{Generate a stratified full DQ report}
\usage{
dq_report_by(
  study_data,
  meta_data,
  label_col,
  meta_data_split = KEY_STUDY_SEGMENT,
  study_data_split,
  ...
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the
metadata with labels of variables}

\item{meta_data_split}{\link{variable attribute} name of a meta data attribute to
split the report in sections of
variables, e.g. all blood-
pressure. By default, reports are
split by \link{KEY_STUDY_SEGMENT}
if available.}

\item{study_data_split}{\link{variable} Name of a study variable to stratify the
report by, e.g. the study centers.}

\item{...}{passed through to \link{dq_report}}
}
\description{
Generate a stratified full DQ report
}
\examples{
\dontrun{ # really long-running example.
load(system.file("extdata", "study_data.RData", package = "dataquieR"))
load(system.file("extdata", "meta_data.RData", package = "dataquieR"))
rep <- dq_report_by(study_data, meta_data, label_col =
  LABEL, study_data_split = "CENTER_0")
rep <- dq_report_by(study_data, meta_data,
  label_col = LABEL, study_data_split = "CENTER_0",
  meta_data_split = NULL
)
}
}
\seealso{
\link{dq_report}
}
