/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FBRuleInfGraph
extends BasicForwardRuleInfGraph
implements BackwardRuleInfGraphI {
    protected BBRuleContext context;
    protected Finder dataFind;
    protected LPBRuleEngine bEngine;
    protected List rawRules;
    protected List rules;
    public static boolean useRETE = true;
    protected boolean useTGCCaching = false;
    public boolean filterFunctors = true;
    protected TransitiveEngine transitiveEngine;
    protected List preprocessorHooks;
    protected TempNodeCache tempNodecache;
    protected Set hiddenNodes;
    static Log logger = LogFactory.getLog((Class)FBRuleInfGraph.class);

    public FBRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(reasoner, schema);
        this.constructorInit(schema);
    }

    public FBRuleInfGraph(Reasoner reasoner, List rules, Graph schema) {
        this(reasoner, rules, schema, ReificationStyle.Minimal);
    }

    public FBRuleInfGraph(Reasoner reasoner, List rules, Graph schema, ReificationStyle style) {
        super(reasoner, rules, schema, style);
        this.rawRules = rules;
        this.constructorInit(schema);
    }

    public FBRuleInfGraph(Reasoner reasoner, List rules, Graph schema, Graph data) {
        super(reasoner, rules, schema, data);
        this.rawRules = rules;
        this.constructorInit(schema);
    }

    private void constructorInit(Graph schema) {
        this.initLP(schema);
        this.tempNodecache = new TempNodeCache(this);
        if (JenaParameters.enableFilteringOfHiddenInfNodes) {
            this.hiddenNodes = new HashSet();
            if (schema != null && schema instanceof FBRuleInfGraph) {
                this.hiddenNodes.addAll(((FBRuleInfGraph)schema).hiddenNodes);
            }
        }
    }

    protected void instantiateRuleEngine(List rules) {
        this.engine = rules != null ? (useRETE ? new RETEEngine(this, rules) : new FRuleEngine(this, rules)) : (useRETE ? new RETEEngine(this) : new FRuleEngine(this));
    }

    private void initLP(Graph schema) {
        if (schema != null && schema instanceof FBRuleInfGraph) {
            LPRuleStore newStore = new LPRuleStore();
            newStore.addAll(((FBRuleInfGraph)schema).bEngine.getRuleStore());
            this.bEngine = new LPBRuleEngine(this, newStore);
        } else {
            this.bEngine = new LPBRuleEngine(this);
        }
    }

    public void setUseTGCCache() {
        this.useTGCCaching = true;
        this.resetTGCCache();
    }

    private void resetTGCCache() {
        this.transitiveEngine = this.schemaGraph != null ? new TransitiveEngine(((FBRuleInfGraph)this.schemaGraph).transitiveEngine) : new TransitiveEngine(new TransitiveGraphCache(ReasonerVocabulary.directSubClassOf.asNode(), RDFS.subClassOf.asNode()), new TransitiveGraphCache(ReasonerVocabulary.directSubPropertyOf.asNode(), RDFS.subPropertyOf.asNode()));
    }

    public ExtendedIterator findDataMatches(Node subject, Node predicate, Node object) {
        return this.dataFind.find(new TriplePattern(subject, predicate, object));
    }

    public ExtendedIterator findDataMatches(TriplePattern pattern) {
        return this.dataFind.find(pattern);
    }

    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of builtin in rule " + rule);
    }

    public void addBRule(Rule brule) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding rule " + brule));
        }
        this.bEngine.addRule(brule);
        this.bEngine.reset();
    }

    public void deleteBRule(Rule brule) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting rule " + brule));
        }
        this.bEngine.deleteRule(brule);
        this.bEngine.reset();
    }

    public void addBRules(List rules) {
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            this.bEngine.addRule(rule);
        }
        this.bEngine.reset();
    }

    public List getBRules() {
        return this.bEngine.getAllRules();
    }

    public List getRules() {
        return this.rules;
    }

    public void setTabled(Node predicate) {
        this.bEngine.tablePredicate(predicate);
        if (this.traceOn) {
            logger.info((Object)("LP TABLE " + predicate));
        }
    }

    private Object getForwardRuleStore() {
        return this.engine.getRuleStore();
    }

    public void addDeduction(Triple t) {
        this.getCurrentDeductionsGraph().add(t);
        if (this.useTGCCaching) {
            this.transitiveEngine.add(t);
        }
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.tempNodecache.getTemp(instance, prop, pclass);
    }

    public void addRuleDuringPrepare(Rule rule) {
        if (this.rules == this.rawRules) {
            this.rules = this.rawRules instanceof ArrayList ? (ArrayList)((ArrayList)this.rawRules).clone() : new ArrayList(this.rawRules);
            this.instantiateRuleEngine(this.rules);
        }
        this.rules.add(rule);
    }

    public void addPreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new ArrayList();
        }
        this.preprocessorHooks.add(hook);
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.isPrepared = true;
            this.rules = this.rawRules;
            Graph data = null;
            if (this.fdata != null) {
                data = this.fdata.getGraph();
            }
            if (this.fdeductions != null && this.fdeductions instanceof FGraph) {
                Graph oldDeductions = this.fdeductions.getGraph();
                oldDeductions.getBulkUpdateHandler().removeAll();
            } else {
                this.fdeductions = new FGraph(this.createDeductionsGraph());
            }
            this.dataFind = data == null ? this.fdeductions : FinderUtil.cascade(this.fdeductions, this.fdata);
            Finder dataSource = this.fdata;
            if (this.useTGCCaching) {
                this.resetTGCCache();
                if (this.schemaGraph != null) {
                    if (this.transitiveEngine.checkOccurance(TransitiveReasoner.subPropertyOf, data) || this.transitiveEngine.checkOccurance(TransitiveReasoner.subClassOf, data) || this.transitiveEngine.checkOccurance(RDFS.domain.asNode(), data) || this.transitiveEngine.checkOccurance(RDFS.range.asNode(), data)) {
                        this.transitiveEngine.insert(((FBRuleInfGraph)this.schemaGraph).fdata, this.fdata);
                    }
                } else if (data != null) {
                    this.transitiveEngine.insert(null, this.fdata);
                }
                Iterator i = this.rules.iterator();
                while (i.hasNext()) {
                    Rule r = (Rule)i.next();
                    if (r.bodyLength() != 0) continue;
                    for (int j = 0; j < r.headLength(); ++j) {
                        ClauseEntry head = r.getHeadElement(j);
                        if (!(head instanceof TriplePattern)) continue;
                        TriplePattern h = (TriplePattern)head;
                        this.transitiveEngine.add(h.asTriple());
                    }
                }
                this.transitiveEngine.setCaching(true, true);
                this.dataFind = FinderUtil.cascade(this.dataFind, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
                dataSource = FinderUtil.cascade(dataSource, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
            }
            this.bEngine.deleteAllRules();
            if (this.preprocessorHooks != null && this.preprocessorHooks.size() > 0) {
                Graph inserts = Factory.createGraphMem();
                Iterator i = this.preprocessorHooks.iterator();
                while (i.hasNext()) {
                    RulePreprocessHook hook = (RulePreprocessHook)i.next();
                    hook.run(this, this.dataFind, inserts);
                }
                if (inserts.size() > 0) {
                    FGraph finserts = new FGraph(inserts);
                    dataSource = FinderUtil.cascade(this.fdata, finserts);
                    this.dataFind = FinderUtil.cascade(this.dataFind, finserts);
                }
            }
            boolean rulesLoaded = false;
            if (this.schemaGraph != null) {
                Graph rawPreload = ((InfGraph)this.schemaGraph).getRawGraph();
                if (rawPreload != null) {
                    this.dataFind = FinderUtil.cascade(this.dataFind, new FGraph(rawPreload));
                }
                rulesLoaded = this.preloadDeductions(this.schemaGraph);
            }
            if (rulesLoaded) {
                this.engine.fastInit(dataSource);
            } else {
                this.addBRules(FBRuleInfGraph.extractPureBackwardRules(this.rules));
                this.engine.init(true, dataSource);
            }
            this.context = new BBRuleContext(this);
        }
    }

    public void rebind() {
        ++this.version;
        if (this.bEngine != null) {
            this.bEngine.reset();
        }
        this.isPrepared = false;
    }

    public void rebindAll() {
        this.rawRules = ((FBRuleReasoner)this.reasoner).getRules();
        this.instantiateRuleEngine(this.rawRules);
        this.rebind();
    }

    public void setTraceOn(boolean state) {
        super.setTraceOn(state);
        this.bEngine.setTraceOn(state);
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.bEngine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    public void setFunctorFiltering(boolean param) {
        this.filterFunctors = param;
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator result = new UniqueExtendedIterator(this.bEngine.find(pattern));
        if (continuation != null) {
            result = result.andThen(continuation.find(pattern));
        }
        if (this.filterFunctors) {
            return result.filterDrop(new Filter(){

                public boolean accept(Object o) {
                    return FBRuleInfGraph.this.accept(o);
                }
            });
        }
        return result;
    }

    public ExtendedIterator findFull(TriplePattern pattern) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        return new UniqueExtendedIterator(this.bEngine.find(pattern));
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    public ExtendedIterator find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    public void reset() {
        ++this.version;
        this.bEngine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.fdata.getGraph().add(t);
        if (this.useTGCCaching && this.transitiveEngine.add(t)) {
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            boolean needReset = false;
            if (this.preprocessorHooks != null && this.preprocessorHooks.size() > 0) {
                if (this.preprocessorHooks.size() > 1) {
                    Iterator i = this.preprocessorHooks.iterator();
                    while (i.hasNext()) {
                        if (!((RulePreprocessHook)i.next()).needsRerun(this, t)) continue;
                        needReset = true;
                        break;
                    }
                } else {
                    needReset = ((RulePreprocessHook)this.preprocessorHooks.get(0)).needsRerun(this, t);
                }
            }
            if (needReset) {
                this.isPrepared = false;
            } else {
                this.engine.add(t);
            }
        }
        this.bEngine.reset();
    }

    public void performDelete(Triple t) {
        ++this.version;
        boolean removeIsFromBase = this.fdata.getGraph().contains(t);
        this.fdata.getGraph().delete(t);
        if (this.useTGCCaching && this.transitiveEngine.delete(t)) {
            if (this.isPrepared) {
                this.bEngine.deleteAllRules();
            }
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.bEngine.deleteAllRules();
            this.isPrepared = false;
        }
        this.bEngine.reset();
    }

    public void close() {
        if (!this.closed) {
            this.bEngine.halt();
            this.bEngine = null;
            this.transitiveEngine = null;
            super.close();
        }
    }

    public ValidityReport validate() {
        this.checkOpen();
        StandardValidityReport report = new StandardValidityReport();
        Triple validateOn = new Triple(Node.createAnon(), ReasonerVocabulary.RB_VALIDATION.asNode(), Functor.makeFunctorNode("on", new Node[0]));
        if (!this.isPrepared) {
            this.prepare();
        }
        this.engine.add(validateOn);
        TriplePattern pattern = new TriplePattern(null, ReasonerVocabulary.RB_VALIDATION_REPORT.asNode(), null);
        ExtendedIterator i = this.findFull(pattern);
        while (i.hasNext()) {
            Object rVal;
            Triple t = (Triple)i.next();
            Node rNode = t.getObject();
            boolean foundReport = false;
            if (!rNode.isLiteral() || !((rVal = rNode.getLiteralValue()) instanceof Functor)) continue;
            Functor rFunc = (Functor)rVal;
            foundReport = true;
            StringBuffer description = new StringBuffer();
            String nature = rFunc.getName();
            String type = rFunc.getArgs()[0].toString();
            String text = rFunc.getArgs()[1].toString();
            description.append(text + "\n");
            description.append("Culprit = " + PrintUtil.print(t.getSubject()) + "\n");
            for (int j = 2; j < rFunc.getArgLength(); ++j) {
                description.append("Implicated node: " + PrintUtil.print(rFunc.getArgs()[j]) + "\n");
            }
            Node culpritN = t.getSubject();
            Resource culprit = null;
            if (culpritN.isURI()) {
                culprit = ResourceFactory.createResource(culpritN.getURI());
            }
            report.add(nature.equalsIgnoreCase("error"), type, description.toString(), culprit);
        }
        return report;
    }

    private static List extractPureBackwardRules(List rules) {
        ArrayList<Rule> bRules = new ArrayList<Rule>();
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (!r.isBackward() || r.bodyLength() <= 0) continue;
            bRules.add(r);
        }
        return bRules;
    }

    protected boolean preloadDeductions(Graph preloadIn) {
        Graph d = this.fdeductions.getGraph();
        FBRuleInfGraph preload = (FBRuleInfGraph)preloadIn;
        if (preload.rules == this.rules) {
            ExtendedIterator i = preload.getDeductionsGraph().find(null, null, null);
            while (i.hasNext()) {
                d.add((Triple)i.next());
            }
            this.addBRules(preload.getBRules());
            this.engine.setRuleStore(preload.getForwardRuleStore());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideNode(Node n) {
        if (!JenaParameters.enableFilteringOfHiddenInfNodes) {
            return;
        }
        if (this.hiddenNodes == null) {
            this.hiddenNodes = new HashSet();
        }
        Set set = this.hiddenNodes;
        synchronized (set) {
            this.hiddenNodes.add(n);
        }
    }

    public void resetLPProfile(boolean enable) {
        this.bEngine.resetProfile(enable);
    }

    public void printLPProfile() {
        this.bEngine.printProfile();
    }

    public boolean accept(Object tin) {
        Triple t = (Triple)tin;
        if (t.getSubject().isLiteral()) {
            return true;
        }
        if (JenaParameters.enableFilteringOfHiddenInfNodes && this.hiddenNodes != null && (this.hiddenNodes.contains(t.getSubject()) || this.hiddenNodes.contains(t.getObject()) || this.hiddenNodes.contains(t.getPredicate()))) {
            return true;
        }
        return this.filterFunctors && Functor.isFunctor(t.getObject());
    }

    public static class RuleStore {
        protected List rawRules;
        protected Object fRuleStore;
        protected List bRules;

        public RuleStore(List rawRules, Object fRuleStore, List bRules) {
            this.rawRules = rawRules;
            this.fRuleStore = fRuleStore;
            this.bRules = bRules;
        }
    }
}

