#' Resultados elecciones presidenciales en Argentina segunda vuelta
#' 2023.
#' @description Corresponde a los datos públicos entregados por el
#'     ministerio del interior de Argentina, referentes a las
#'     elecciones presidenciales efectuadas el año 2023
#' @usage data(segundavuelta)
#' @format Este set de datos contiene las siguientes columnas:
#'     \describe{ \item{año}{Es el año calendario en el cual se lleva
#'     a cabo la elección.}  \item{recuento_id}{Indica el
#'     identificador numérico del tipo de recuento.}
#'     \item{distrito_id}{Indica el identificador numérico del
#'     distrito origen de los datos.}  \item{seccion_nombre}{Indica el
#'     nombre de la sección origen de los datos.}
#'     \item{mesa_id}{Identificador de la mesa origen de los datos.}
#'     \item{cargo_id}{Identificador del cargo para el cual se han
#'     contado los votos.}  \item{agrupacion_nombre}{Indica nombre de
#'     la agrupación política a la cual se han consignado los
#'     votos. Puede ser nulo en el caso de votos no positivos.}
#'     \item{estado_final}{Indica si el telegrama ha sido totalizado
#'     en el recuento provisional. Este campo podrá ser nulo para los
#'     recuentos definitivos.}  
#'     \item{eleccion_tipo}{Es el tipo de
#'     elección.}  
#'     \item{recuento_tipo}{Indica el tipo de recuento
#'     origen de los datos.}  
#'     \item{distrito_nombre}{Indica el nombre
#'     del distrito origen de los datos.}  
#'     \item{circuito_id}{Indica
#'     el identificador numérico o alfanumérico del circuito origen de
#'     los datos.}  
#'     \item{mesa_tipo}{Indicador del tipo de mesa origen
#'     de los datos.}  
#'     \item{cargo_nombre}{Indica el nombre del cargo
#'     para el cual se han contado los votos.}
#'     \item{votos_tipo}{Indica el tipo de votos que se han
#'     contabilizado.}  
#'     \item{seccionprovincial_id}{Indica el
#'     identificador numérico de la sección provincial origen de los
#'     datos.}  
#'     \item{eleccion_id}{Indica el identificador numérico
#'     del tipo de elección.}  
#'     \item{padron_tipo}{Indica el tipo de
#'     padrón del cual provienen los datos.}  
#'     \item{seccion_id}{Indica
#'     el identificador numérico de la sección origen de los datos.}
#'     \item{circuito_nombre}{Indica el identificador numérico o
#'     alfanumérico del circuito origen de los datos.}
#'     \item{mesa_electores}{Cantidad de electores de la mesa origen
#'     de los datos.}  
#'     \item{agrupacion_id}{Indicador de la agrupación
#'     política. Puede ser nulo en el caso de votos no positivos.}
#'     \item{votos_cantidad}{Cantidad de votos contabilizados.}
#'     \item{seccionprovincial_nombre}{Indica el nombre de la sección
#'     provincial origen de los datos.}
#'     }
#' @source Los datos fueron obtenidos de la Direccion Nacional
#'     Electoral (DINE) de Argentina
#' @examples
#' data(segundavuelta)
#' df<-segundavuelta    
#' head(df) 
#' table(df$distrito_nombre)
#' table(df$mesa_tipo,df$distrito_nombre)
#' tapply(df$votos_cantidad, df$distrito_nombre, summary)
'segundavuelta'
