% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDataDatana.r
\docType{data}
\name{regNothofagus}
\alias{regNothofagus}
\title{Contains information about regeneration of Nothofagus seedlings.}
\format{
Contains 15 variables, as follows:
\describe{
  \item{site}{Id site of study.}
  \item{plot}{Number of plot.}
\item{scar}{Scarification in percentage of total area.}
\item{x.trans.total}{Transmitted radiation in percentage.}
\item{kPa}{Soil resistance to penetration.}
\item{SWC}{Soil water content.}
\item{SM}{Exposed mineral soil.}
\item{litter}{Litter cover in percentage.}
\item{CWD}{Ocular estimation in the regeneration plot in percentage.}
\item{MT}{Microtopography. 1 plane, 2 convex, 3 concave, 4 mixed
 (convex and concave) in the regeneration plot.}
\item{S}{Ground-layer vascular species richness in the regeneration plot..}
\item{LLES}{Long-lived early-seral tree species (N. dombeyi , N. alpina , 
Nothofagus pumilio ).}
\item{SLES}{Short-lived early-seral plants (Ribes spp. and Fuchsia sp).}
\item{LLLS}{Long-lived late-seral tree species (L. philippiana and 
Dasyphyllum diacantaoides ).}
\item{log.bam}{Logarithm of the cover of bamboo (\%) in the regeneration 
plot.}
 }
}
\source{
The data were obtained from the DRYAD repository
 at \doi{10.5061/dryad.3q977}
}
\usage{
data(regNothofagus)
}
\description{
Dataset contains 442 observations.
}
\examples{
data(regNothofagus)    
head(regNothofagus) 
}
\references{
Soto D, Puettmann K.2018. Topsoil removal through scarification improves 
natural regeneration
in high-graded Nothofagus old-growth forests.
 Journal Applied Ecology 55: 967- 976.
}
\keyword{datasets}
