% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xymultiplot.R
\name{xymultiplot}
\alias{xymultiplot}
\title{Figure of a matrix of scatterplots and histograms for several 
variables.}
\usage{
xymultiplot(
  x,
  smooth = TRUE,
  scale = FALSE,
  density = TRUE,
  digits = 2,
  method = "pearson",
  pch = 20,
  lm = FALSE,
  cor = TRUE,
  jiggle = FALSE,
  factor = 2,
  col.hist = "cyan",
  col.densi.curve = "black",
  show.points = TRUE,
  col.points = "gray",
  smoother = FALSE,
  col.smooth = "red",
  ellipses = FALSE,
  col.ellip = "blue",
  col.cent.point = "green",
  rug = TRUE,
  breaks = "Sturges",
  cex.cor = 1,
  ci = FALSE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{x}{is a dataframe containing all the numeric variables to be used 
for drawing the panel plot}

\item{smooth}{a logical value for drawing smooth curves. The default is 
set to TRUE.}

\item{scale}{scales the correlation font by the size of the absolute 
correlation. The default is set to FALSE.}

\item{density}{a logical value for drawing a density curve. The default
is set to TRUE.}

\item{digits}{an optional numeric value for the digits to be used for 
drawing the correlation coefficient in the panel.
  Defaults is set to 2.}

\item{method}{a string giving the method to be used for computing the
correlation coefficient. Default is set to "pearson".}

\item{pch}{The plot character (The default is 20, which looks like '.').}

\item{lm}{Plot the linear fit rather than the LOESS smoothed fits. 
The default is FALSE.}

\item{cor}{If plotting regressions, should correlations be reported? 
The default is TRUE.}

\item{jiggle}{Should the points be jittered before plotting? 
The default is FALSE.}

\item{factor}{factor for jittering (1-5), therefore only needed 
if "jiggle" is set to TRUE.}

\item{col.hist}{a string giving the color to be used for the histograms
of the panel. Default is set to "cyan".}

\item{col.densi.curve}{a string with the name of the color to be used for
the density curve. The default is set to "black".}

\item{show.points}{a logical value for drawing the points in the
scatter-plots. Defauls is set to TRUE.}

\item{col.points}{a string giving the color to be used for the data points. 
Default is set to "gray".}

\item{smoother}{If TRUE, then smooth.scatter the data points-slow but
pretty with lots of subjects}

\item{col.smooth}{a string giving the color to be used for the smoothed
curve of the scatterplot. Default is set to "red".}

\item{ellipses}{an optional logical value for drawing an ellipse for the
scatter-plots. The default is set to FALSE.}

\item{col.ellip}{a string giving the color to be used for the ellipse of 
the scatterplot. The default is set to "blue".}

\item{col.cent.point}{a string giving the color to be used for the centroid
point of the ellipse of the scatterplot. The default is set to "blue".}

\item{rug}{a logical value for drawing the rugs in the histograms.
Defauls is set to TRUE.}

\item{breaks}{a string giving the method to be used for obtaining the 
breaks of the histogram. Defauls is set to "Sturges".}

\item{cex.cor}{If this is specified, this will change the size of the 
text in the correlations. this 
 allows one to also change the size of the points in the plot by 
 specifying the normal cex values. If just
 specifying cex, it will change the character size, if cex.cor is
  specified, then cex will function to change the point size.}

\item{ci}{Draw confidence intervals for the linear model or for the 
loess fit, defaults to ci=FALSE. If confidence
  intervals are not drawn, the fitting function is lowess.}

\item{alpha}{an optional numeric value for the significance level.
Defauls is set to 0.05.}

\item{...}{other \link[graphics]{graphical parameters} (see \code{\link[graphics]{par}} and
    section \sQuote{Details} below).}
}
\value{
This function returns a multipanel of scatterplots and histograms
}
\description{
The function produces a panel of multiple scatterplots and histograms, 
showing 
the correlation coefficient among all pairs of variables. Notice that 
the data must contain only numeric variables.
}
\details{
Generates a multipanel (matrix) of scatterplots and histograms to explore 
potential relationships among variables.
}
\examples{
##First example
data(bears2)
head(bears2)
df <- bears2[,c('peso','edad','cabezaL','cabezaA','largo','pechoP')]
descstat(df)
xymultiplot(df)
xymultiplot(df,ellipse=TRUE)
xymultiplot(df,ellipses=TRUE,col.cent.point = "yellow",
 col.densi.curve = "dark green",col.hist = "white")
}
\references{
- Salas-Eljatib C. 2021. Análisis de datos con el programa estadístico R: 
una introducción aplicada. Ediciones Universidad Mayor. Santiago, Chile. 
\url{https://eljatib.com}
}
\author{
A modification of Christian Salas-Eljatib of the 
function pairs.panels of the package \eqn{psych}.
}
