% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{hawaii2}
\alias{hawaii2}
\title{Incremento corriente anual en diametro de una especie tropical en Hawaii}
\format{
Estos datos contienen las siguientes columnas:
\describe{
  \item{arb.id}{Codigo identificador del árbol. La primera letra del ID representa
  un cohorte. Hay seis cohortes que representan una cronosecuencia.}
  \item{dap}{Diametro a la altura del pecho, en cm.}
  \item{htot}{Altura total, en m.}
  \item{area.copa}{Área de copa, en metros cuadrados.}
  \item{ind.comp}{Competition index (Basal area of nearest neighbor divided by square of distance to nearest neighbor plus
         basal area of second nearest neighbor divided by square of distance to second nearest neighbor).}
  \item{ica.1986}{Incremento corriente anual durante el año 1986, en mm.}
  \item{ica.1987}{Incremento corriente anual durante el año 1987, en mm.}
  \item{ica.1988}{Incremento corriente anual durante el año 1988, en mm.}
 }
}
\source{
Los datos fueron obtenidos desde Gerrish and Mueller-Dombois (1999).
}
\usage{
data(hawaii)
}
\description{
Tamaño del árbol, competencia, e incremento corriente anual de árboles de Metrosideros polymorpha 
colectado en el volcan Kilauea, en Hawaii. Los datos contienen 64 observaciones de incremento corriente anual 
(definido como el incremento en diametro en un año calendario) de cada árbol. Estos incrementos
 fueron medidos desde el año 1986 a 1988 usando bandas dendrometricas.
}
\examples{
data(hawaii2)    
head(hawaii2) 
}
\references{
Gerrish G, Mueller-Dombois D. 1999. Measuring stem growth rates for
determining age and cohort analysis of a tropical evergreen tree.
Pacific Science. 53(4): 418-429.
}
\keyword{datasets}
