% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{eucaplotsampleh}
\alias{eucaplotsampleh}
\title{A sample plot from a Eucalyptus globulus plantation, with height measurements in a sub-sample of trees.}
\format{
The data frame contains four variables as follows:
\describe{
  \item{dbh}{Diameter at breast height, in cm.}
  \item{health}{health status (1: good, 2: medium, 3: bad).}
  \item{shape}{stem shape for timber purposes (1: good, 2: medium, 3: bad).}
  \item{crown.class}{Crown class (1: superior, 2: intermedium, 3: lower).}
  \item{toth}{Total height, in m. Only measured in a sub-sample of trees.}
 }
}
\source{
The data were provided courtesy of Dr Christian Salas-Eljatib (Chile).
}
\usage{
data(eucaplotsampleh)
}
\description{
Data from a sample plot, but height measurements are only available for a sub-sample of trees. 
The sample plot (500 m\eqn{^{2}}{^2} of size) was established in a forestry plantation of Eucalyptus globulus near Gorbea, 
Southern Chile. The plantation is 15 yr-old and had been subject to three thinnings.
}
\examples{
data(eucaplotsampleh)    
head(eucaplotsampleh) 
}
\keyword{datasets}
