% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{add_icons}
\alias{add_icons}
\alias{icons_options}
\title{Add icons}
\usage{
add_icons(p, lon, lat, ...)

icons_options(p, class = "datamaps-icon", ...)
}
\arguments{
\item{p}{a datamaps object.}

\item{lon, lat}{coordinates.}

\item{...}{any other parameter.}

\item{class}{a valid CSS class.}
}
\description{
Add icons at coordinates.
}
\examples{
coords <- data.frame(
  city = c("London", "New York", "Beijing", "Sydney"),
  lon = c(-0.1167218, -73.98002, 116.3883, 151.18518),
  lat = c(51.49999, 40.74998, 39.92889, -33.92001)
)

coords \%>\% 
  datamaps() \%>\% 
  add_icons(lon, lat)
                     
}
\seealso{
\href{https://github.com/jdlubrano/datamaps-icons-plugin}{Plugin documentation}
}
