% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{config_bubbles}
\alias{config_bubbles}
\title{Configure bubbles}
\usage{
config_bubbles(p, popup.on.hover = TRUE, highlight.on.hover = TRUE,
  fill.opacity = 0.75, animate = TRUE, border.width = 1,
  border.opacity = 1, border.color = "#FDFDFD",
  highlight.fill.color = "#FC8D59", highlight.border.opacity = 1,
  highlight.border.color = "rgba(250, 15, 160, 0.2)",
  highlight.fill.opacity = 0.85, highlight.border.width = 2,
  exit.delay = 100, ...)
}
\arguments{
\item{p}{a datamaps object.}

\item{popup.on.hover}{whether to show popover.}

\item{highlight.on.hover}{whether to enable popover.}

\item{fill.opacity}{opacity of bubbles.}

\item{animate}{Wether to animate bubbles.}

\item{border.width}{width of bubbles.}

\item{border.opacity}{opacity of bubbles' border.}

\item{border.color}{color of bubbles' border.}

\item{highlight.fill.color}{bubbles fill color on hover.}

\item{highlight.border.opacity}{bubbles opacity on hover.}

\item{highlight.border.color}{bubble's border opacity on hover.}

\item{highlight.fill.opacity}{bubble's opacity on hover.}

\item{highlight.border.width}{bubble's width on hover.}

\item{exit.delay}{highlight delay.}

\item{...}{any other parameter.}
}
\description{
Define options of the bubbles.
}
\examples{
coords <- data.frame(city = c("London", "New York", "Beijing", "Sydney"),
                     lon = c(-0.1167218, -73.98002, 116.3883, 151.18518),
                     lat = c(51.49999, 40.74998, 39.92889, -33.92001),
                     values = runif(4, 3, 20))

coords \%>\%
    datamaps(default = "lightgray") \%>\%
    add_bubbles(lon, lat, values * 2, values, city) \%>\%
    config_bubbles(highlight.border.color = "rgba(0, 0, 0, 0.2)",
                   fill.opacity = 0.6,
                   border.width = 0.7,
                   highlight.border.width = 5,
                   highlight.fill.color = "green")

}
