% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incorporate_attr.R
\name{incorporate_attr}
\alias{incorporate_attr}
\title{Incorporate attributes as metadata to an original dataset.}
\usage{
incorporate_attr(my.data, data.dictionary, main_string)
}
\arguments{
\item{my.data}{Data.frame. The data set to add attributes as metadata.}

\item{data.dictionary}{Data frame. The data dictionary has all variable names, 
and variable descriptions that will explain an original dataset.}

\item{main_string}{A character string describing the original dataset.}
}
\value{
This function will return an R dataset containing metadata stored in 
its attributes. Attributes added will include: a data dictionary, number of columns, 
number of rows, the name of the author or user who created the dictionary and added it,
the time when it was last edited and a brief description of the original dataset.
}
\description{
\code{incorporate_attr} adds attributes to an original dataset as metadata, 
including a data dictionary, among other attributes. This is the third function 
used in this package. For the function to run, the following parameters are needed.
}
\examples{
# example original data set for which a dictionary will be made
data("esoph")
my.data <- esoph

# Linker: Add description for each variable names and variable type
variable_description <- c("age group in years", "alcohol consumption in gm/day", 
"tobacco consumption in gm/day", "number of cases (showing range)", 
"number of controls (showing range)")
variable_type <- c(0, 0, 0, 0, 0)
linker <- build_linker(my.data = my.data, variable_description = variable_description, 
variable_type = variable_type)
linker

# Data dictionary
# For this data set, no further option description is needed.
dictionary <- build_dict(my.data = my.data, linker = linker, option_description = NULL, 
prompt_varopts = FALSE)
dictionary

# Create main_string for attributes
main_string <- "This dataset describes tobacco and alcohol consumption at different age groups."
complete_dataset <- incorporate_attr(my.data = my.data, data.dictionary = dictionary, 
main_string = main_string)
complete_dataset
attributes(complete_dataset)

}
