% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_360.R
\name{search_360}
\alias{search_360}
\title{Search TC/Govdata360 indicators, countries, categories, and dataset lists}
\usage{
search_360(
  search_string = "World Bank",
  site = "tc",
  search_type = NULL,
  limit_results = NULL
)
}
\arguments{
\item{search_string}{string to query in TC/Govdata360}

\item{site}{string pertaining to the data360 site to download data from.
Possible choices: 'tc' for TCdata360, 'gov' for Govdata360}

\item{search_type}{NULL (optional). Character vector of search types to include.
Possible values include: 'indicator', 'category', 'country'
Leaving this NULL will return all possible search results.}

\item{limit_results}{NULL (optional). Number pertaining to the number of top results to be kept.}
}
\value{
List containing top search results
}
\description{
Searches using the TCdata360 API at \url{https://tcdata360.worldbank.org/docs}
or Govdata360 API at \url{https://govdata360.worldbank.org/docs}.
The function generates a wide dataframe containing the top search results related to the query.
}
\details{
Hint: Want to use your search results to call data? Helpful functions include:
\itemize{
  \item See \code{\link{get_data360}} to get actual indicator/dataset/country-level data.
  \item See \code{\link{get_metadata360}} to get indicator/dataset/country-level metadata.
 \item See \code{\link{get_resources360}} to get additional resource information.
}
}
\examples{
## Since all functions download data through API, these are wrapped with
## the "donttest" function as advised by CRAN
#search a country's code in TCdata360
\donttest{search_360('Philippines', search_type = 'country')}

#search for top 10 relevant indicator codes in TCdata360
\donttest{search_360('GDP', search_type = 'indicator', limit_results = 10)}

#search for top 10 indicators of a database in TCdata360
\donttest{search_360('World Development Indicators', search_type = 'indicator',
limit_results = 10)}

#search for top 10 indicators of a data provider in TCdata360
\donttest{search_360('WEF', search_type = 'indicator', limit_results = 10)}

#search for top 10 relevant categories in Govdata360
\donttest{search_360('Governance', site='gov', search_type = 'category', limit_results = 10)}
}
