% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_list.R
\name{as.list.Node}
\alias{as.list.Node}
\alias{ToListSimple}
\alias{ToListExplicit}
\title{Convert a \code{data.tree} structure to a list-of-list structure}
\usage{
\method{as.list}{Node}(x, mode = c("simple", "explicit"),
  unname = FALSE, nameName = ifelse(unname, "name", ""),
  childrenName = "children", rootName = "", keepOnly = NULL, ...)

ToListSimple(x, nameName = "name", ...)

ToListExplicit(x, unname = FALSE, nameName = ifelse(unname, "name",
  ""), childrenName = "children", ...)
}
\arguments{
\item{x}{The Node to convert}

\item{mode}{How the list is structured. "simple" (the default) will add children directly as nested lists.
"explicit" puts children in a separate nested list called \code{childrenName}}

\item{unname}{If TRUE, and if \code{mode} is "explicit", then the nested children list will not have named arguments. This
can be useful e.g. in the context of conversion to JSON, if you prefer the children to be
an array rather than named objects.}

\item{nameName}{The name that should be given to the name element}

\item{childrenName}{The name that should be given to the children nested list}

\item{rootName}{The name of the node. If provided, this overrides \code{Node$name}}

\item{keepOnly}{A character vector of fields to include in the result. If \code{NULL} (the default), all fields are kept.}

\item{...}{Additional parameters passed to \code{as.list.Node}}
}
\description{
Convert a \code{data.tree} structure to a list-of-list structure
}
\examples{
data(acme)

str(ToListSimple(acme))
str(ToListSimple(acme, keepOnly = "cost"))

str(ToListExplicit(acme))
str(ToListExplicit(acme, unname = TRUE))
str(ToListExplicit(acme, unname = TRUE, nameName = "id", childrenName = "descendants"))


}
