% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBenchmarks.R
\name{runBenchmarks}
\alias{runBenchmarks}
\title{Function to run a set of predefined benchmarks for different \code{data.table} functions with varying thread counts}
\usage{
runBenchmarks(rowCount, colCount, threadCount, times = 10, verbose = TRUE)
}
\arguments{
\item{rowCount}{The number of rows in the \code{data.table}.}

\item{colCount}{The number of columns in the \code{data.table}.}

\item{threadCount}{The total number of threads to use.}

\item{times}{The number of times the benchmarks are to be run.}

\item{verbose}{Option (logical) to enable or disable detailed message printing.}
}
\value{
A \code{data.table} containing benchmarked timings for each \code{data.table} function with different thread counts.
}
\description{
Function to run a set of predefined benchmarks for different \code{data.table} functions with varying thread counts
}
\details{
Benchmarks various \code{data.table} functions that are parallelizable (\code{setorder}, \code{GForce_sum}, \code{subsetting}, \code{frollmean}, \code{fcoalesce}, \code{between}, \code{fifelse}, \code{nafill}, and \code{CJ}) with varying thread counts.
}
