% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clientsideFunction}
\alias{clientsideFunction}
\title{Define a clientside callback}
\usage{
clientsideFunction(namespace, function_name)
}
\arguments{
\item{namespace}{Character. Describes where the JavaScript function resides (Dash will look
for the function at \code{window[namespace][function_name]}.)}

\item{function_name}{Character. Provides the name of the JavaScript function to call.}
}
\description{
Create a callback that updates the output by calling a clientside (JavaScript) function instead of an R function.
Note that it is also possible to specify JavaScript as a character string instead of passing \code{clientsideFunction}.
In this case Dash will inline your JavaScript automatically, without needing to save a script inside \code{assets}.
}
\details{
With this signature, Dash's front-end will call \code{window.my_clientside_library.my_function} with the current
values of the \code{value} properties of the components \code{my-input} and \code{another-input} whenever those values change.
Include a JavaScript file by including it your \verb{assets/} folder. The file can be named anything but you'll need to
assign the function's namespace to the \code{window}. For example, this file might look like:
\preformatted{window.my_clientside_library = \{
my_function: function(input_value_1, input_value_2) \{
   return (
     parseFloat(input_value_1, 10) +
       parseFloat(input_value_2, 10)
   );
\}
\}
}
}
\examples{
\dontrun{
app$callback(
  output('output-clientside', 'children'),
  params=list(input('input', 'value')),
  clientsideFunction(
  namespace = 'my_clientside_library',
  function_name = 'my_function'
  )
)

# Passing JavaScript as a character string
app$callback(
 output('output-clientside', 'children'),
 params=list(input('input', 'value')),
 "function (value) {
       return 'Client says \"' + value + '\"';
 }"
)}
}
