% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.structure.run.r
\name{utils.structure.run}
\alias{utils.structure.run}
\title{Utility function to run strcture}
\usage{
utils.structure.run(
  g,
  k.range = NULL,
  num.k.rep = 1,
  label = NULL,
  delete.files = TRUE,
  exec = "structure",
  ...
)
}
\arguments{
\item{g}{a gtypes object [see \code{strataG}].}

\item{k.range}{vector of values to for \code{maxpop} in multiple runs. If set
to \code{NULL}, a single STRUCTURE run is conducted with \code{maxpops}
groups. If specified, do not also specify \code{maxpops}.}

\item{num.k.rep}{number of replicates for each value in \code{k.range}.}

\item{label}{label to use for input and output files}

\item{delete.files}{logical. Delete all files when STRUCTURE is finished?}

\item{exec}{name of executable for STRUCTURE. Defaults to "structure".}

\item{...}{arguments to be passed to \code{structureWrite}.}
}
\value{
\describe{ \item{\code{structureRun}}{a list where each element is a
list with results from \code{structureRead} and a vector of the filenames
used} \item{\code{structureWrite}}{a vector of the filenames used by
STRUCTURE} \item{\code{structureRead}}{a list containing: \describe{
\item{\code{summary}}{new locus name, which is a combination of loci in
group} \item{\code{q.mat}}{data.frame of assignment probabilities for each
id} \item{\code{prior.anc}}{list of prior ancestry estimates for each
individual where population priors were used} \item{\code{files}}{vector of
input and output files used by STRUCTURE} \item{\code{label}}{label for the
run} } } }
}
\description{
These functions were copied from package strataG, which is no longer on CRAN (maintained by Eric Archer)
}
\author{
Bernd Gruber (bugs? Post to
 \url{https://groups.google.com/d/forum/dartr}); original implementation of
 Eric Archer \url{https://github.com/EricArcher/strataG}
}
