% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.sexlinked.r
\name{gl.report.sexlinked}
\alias{gl.report.sexlinked}
\title{Identify loci that are sex linked in specimens in a genlight \code{adegenet} object}
\usage{
gl.report.sexlinked(
  x,
  sex = NULL,
  t.het = 0,
  t.hom = 0,
  t.pres = 0,
  plot = TRUE,
  verbose = NULL
)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{sex}{-- factor that defines the sex of individuals. See explanation above.}

\item{t.het}{-- tolerance, that is t.het=0.05 means that 5\% of the heterogametic sex can be homozygous and still be regarded as consistent with a sex specific marker [default 0]}

\item{t.hom}{-- tolerance, that is t.hom=0.05 means that 5\% of the homogametic sex can be heterozygous and still be regarded as consistent with a sex specific marker [default 0]}

\item{t.pres}{-- tolerance, that is t.pres=0.05 means that a silicodart marker can be present in either of the sexes and still be regarded as a sex-linked marker. [default 0]}

\item{plot}{-- creates a plot that shows the heterozygosity of males and females at each loci for SNP data or percentage of present/absent in the case of silicodart data.
be regarded as consistent with a sex specific marker [default 0]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
two list of sex specific loci, for XX/XY and ZZ/ZW systems.
}
\description{
Alleles unique to the Y or W chromosome and monomorphic on the X chromosomes will appear in the SNP dataset as 
genotypes that are heterozygotic in all individuals of the heterogametic sex and homozygous in all individuals 
of the homogametic sex.
}
\details{
This script will identify loci with alleles that behave in this way, as putative sex specific SNP markers.

Sex of the individuals for which sex is known with certainty can be provided via a factor (equal to the length of the number of individuals) or to be held in the variable \code{x@other$ind.metrics$sex}.
Coding is: M for male, F for female, U or NA for unknown/missing. The script abbreviates the entries here to the first character. So coding of "Female" and "Male" works as well. Character are also converted to upper cases.
}
\examples{
cat("does not work yet")
#result <- gl.sexlinkage(testset.gl)
}
\author{
Arthur Georges, Bernd Gruber & Floriaan Devloo-Delva (Post to \url{https://groups.google.com/d/forum/dartr})
}
