% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.keep.pop.r
\name{gl.keep.pop}
\alias{gl.keep.pop}
\title{Remove all but specified populations from a genelight \{adegenet\} object}
\usage{
gl.keep.pop(x, pop.list, recalc = FALSE, mono.rm = TRUE, v = 2)
}
\arguments{
\item{x}{-- name of the genlight object containing SNP genotypes or a genind object containing presence/absence data [required]}

\item{pop.list}{-- a list of populations to be kept [required]}

\item{recalc}{-- Recalculate the locus metadata statistics [default FALSE]}

\item{mono.rm}{-- Remove monomorphic loci [default TRUE]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A genlight object with the reduced data
}
\description{
Individuals are assigned to populations based on the specimen metadata data file (csv) used with gl.read.dart().
}
\details{
The script, having deleted the specified populations, optionally identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r). The script also optionally
recalculates statistics made redundant by the deletion of individuals from the dataset.

The script returns a genlight object with the new population assignments and the recalculated locus metadata.
}
\examples{
   gl <- gl.keep.pop(testset.gl, pop.list=c("EmsubRopeMata","EmvicVictJasp"))
}
\seealso{
\code{\link{gl.filter.monomorphs}}

\code{\link{gl.recalc.metrics}}
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
