% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.define.pop.r
\name{gl.define.pop}
\alias{gl.define.pop}
\title{Define a new population in a genelight \{adegenet\} object on the basis of specified individuals}
\usage{
gl.define.pop(x, ind.list, new, v = 2)
}
\arguments{
\item{x}{-- name of the genlight object containing SNP genotypes [required]}

\item{ind.list}{-- a list of individuals to be assigned to the new population [required]}

\item{new}{-- name of the new population}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A genlight object with the redefined population structure
}
\description{
The script reassigns existing individuals to a new population and removes their existing population assignment
}
\details{
The script returns a genlight object with the new population assignment.
}
\examples{
   gl <- gl.define.pop(testset.gl, ind.list=c("AA019073","AA004859"), new="newguys")
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
