% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.parent.offspring.r
\name{gl.filter.parent.offspring}
\alias{gl.filter.parent.offspring}
\title{Filters putative parent offspring within a population}
\usage{
gl.filter.parent.offspring(
  x,
  min.rdepth = 12,
  min.reproducibility = 1,
  range = 1.5,
  method = "best",
  rm.monomorphs = FALSE,
  plot_theme = theme_dartR(),
  plot_colors = gl.colors(2),
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP genotypes [required].}

\item{min.rdepth}{Minimum read depth to include in analysis [default 12].}

\item{min.reproducibility}{Minimum reproducibility to include in analysis
[default 1].}

\item{range}{Specifies the range to extend beyond the interquartile range for
delimiting outliers [default 1.5 interquartile ranges].}

\item{method}{Method of selecting the individual to retain from each pair of
parent offspring relationship, 'best' (based on CallRate) or 'random'
[default 'best'].}

\item{rm.monomorphs}{If TRUE, remove monomorphic loci after filtering
individuals [default FALSE].}

\item{plot_theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot_colors}{List of two color names for the borders and fill of the
plots [default gl.colors(2)].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified
by the global working directory or tempdir()]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
the filtered genlight object without A set of individuals in
parent-offspring relationship. NULL if no parent-offspring relationships were
found.
}
\description{
This script removes individuals suspected of being related as
parent-offspring,using the output of the function
\code{\link{gl.report.parent.offspring}}, which examines the frequency of
pedigree inconsistent loci, that is, those loci that are homozygotes in the
parent for the reference allele, and homozygous in the offspring for the
alternate allele. This condition is not consistent with any pedigree,
regardless of the (unknown) genotype of the other parent.
The pedigree inconsistent loci are counted as an indication of whether or not
it is reasonable to propose the two individuals are in a parent-offspring
relationship.
}
\details{
If two individuals are in a parent offspring relationship, the true number of
pedigree inconsistent loci should be zero, but SNP calling is not infallible.
Some loci will be miss-called. The problem thus becomes one of determining if
the two focal individuals have a count of pedigree inconsistent loci less
than would be expected of typical unrelated individuals. There are some quite
sophisticated software packages available to formally apply likelihoods to
the decision, but we use a simple outlier comparison.
To reduce the frequency of miss-calls, and so emphasize the difference
between true parent-offspring pairs and unrelated pairs, the data can be
filtered on read depth. Typically minimum read depth is set to 5x, but you
can examine the distribution of read depths with the function
\code{\link{gl.report.rdepth}} and push this up with an acceptable loss of
loci. 12x might be a good minimum for this particular analysis. It is
sensible also to push the minimum reproducibility up to 1, if that does not
result in an unacceptable loss of loci. Reproducibility is stored in the slot
 \code{@other$loc.metrics$RepAvg} and is defined as the proportion of
 technical replicate assay pairs for which the marker score is consistent.
You can examine the distribution of reproducibility with the function
\code{\link{gl.report.reproducibility}}.
Note that the null expectation is not well defined, and the power reduced, if
the population from which the putative parent-offspring pairs are drawn
contains many sibs. Note also that if an individual has been genotyped twice
in the dataset, the replicate pair will be assessed by this script as being
in a parent-offspring relationship.
You should run \code{\link{gl.report.parent.offspring}} before filtering. Use
this report to decide min.rdepth and min.reproducibility and assess impact on
your dataset.
Note that if your dataset does not contain RepAvg or rdepth among the locus
metrics, the filters for reproducibility and read depth are no used.
 Examples of other themes that can be used can be consulted in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
out <- gl.filter.parent.offspring(testset.gl[1:10, 1:50])
}
\seealso{
\code{\link{gl.report.rdepth}} , \code{\link{gl.report.reproducibility}},
\code{\link{gl.report.parent.offspring}}
}
\author{
Custodian: Arthur Georges -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
\concept{filter functions}
