% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.allele.freq.r
\name{gl.allele.freq}
\alias{gl.allele.freq}
\title{Generates percentage allele frequencies by locus and population}
\usage{
gl.allele.freq(x, percent = FALSE, by = "pop", simple = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or Tag P/A
(SilicoDArT) data [required].}

\item{percent}{If TRUE, percentage allele frequencies are given, if FALSE
allele proportions are given [default FALSE]}

\item{by}{If by='popxloc' then breakdown is given by population and locus; if by='pop'
then breakdown is given by population with statistics averaged across loci; if by='loc'
then breakdown is given by locus with statistics averaged across individuals [default 'pop']}

\item{simple}{A legacy option to return a dataframe with the frequency of the 
reference allele (alf1) and the frequency of the alternate allele (alf2) by locus [default FALSE]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity]}
}
\value{
A matrix with allele (SNP data) or presence/absence frequencies
(Tag P/A data) broken down by population and locus
}
\description{
This is a support script, to take SNP data or SilicoDArT presence/absence
data grouped into populations in a genlight object \{adegenet\} and generate
a table of allele frequencies for each population and locus
}
\examples{
gl.allele.freq(testset.gl,percent=FALSE,by='pop')
gl.allele.freq(testset.gl,percent=FALSE,by="loc")
gl.allele.freq(testset.gl,percent=FALSE,by="popxloc")
gl.allele.freq(testset.gl,simple=TRUE)


}
\seealso{
Other unmatched report: 
\code{\link{gl.report.basics}()},
\code{\link{gl.report.diversity}()},
\code{\link{gl.report.heterozygosity}()},
\code{\link{gl.report.polyploid_heterozygosity}()}
}
\author{
Custodian: Arthur Georges (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{unmatched report}
