% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.join.r
\name{gl.join}
\alias{gl.join}
\title{Combines two dartR genlight objects}
\usage{
gl.join(x1, x2, verbose = NULL)
}
\arguments{
\item{x1}{Name of the first genlight object [required].}

\item{x2}{Name of the first genlight object [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
A new genlight object
}
\description{
This function combines two genlight objects and their associated metadata.
The history associated with the two genlight objects is cleared from the new
genlight object. The individuals/samples must be the same in each genlight
object.
The function is typically used to combine datasets from the same service
where the files have been split because of size limitations. The data is read
in from multiple csv files, then the resultant genlight objects are combined.
This function works with both SNP and Tag P/A data.
}
\examples{
x1 <- testset.gl[,1:100]
x1@other$loc.metrics <-  testset.gl@other$loc.metrics[1:100,]
nLoc(x1)
x2 <- testset.gl[,101:150]
x2@other$loc.metrics <-  testset.gl@other$loc.metrics[101:150,]
nLoc(x2)
gl <- gl.join(x1, x2, verbose=2)
nLoc(gl)

}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sort}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
