% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.pop.r
\name{gl.dist.pop}
\alias{gl.dist.pop}
\title{Calculates a distance matrix for populations with SNP genotypes in a
 genlight object}
\usage{
gl.dist.pop(
  x,
  method = "euclidean",
  plot.out = TRUE,
  scale = FALSE,
  output = "dist",
  plot_theme = theme_dartR(),
  plot_colors = gl.colors(2),
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight containing the SNP genotypes [required].}

\item{method}{Specify distance measure [default euclidean].}

\item{plot.out}{If TRUE, display a histogram of the genetic distances, and a
whisker plot [default TRUE].}

\item{scale}{If TRUE and method='Euclidean', the distance will be scaled to 
fall in the range [0,1] [default FALSE].}

\item{output}{Specify the format and class of the object to be returned, 
dist for a object of class dist, matrix for an object of class matrix [default "dist"].}

\item{plot_theme}{User specified theme [default theme_dartR()].}

\item{plot_colors}{Vector with two color names for the borders and fill
[default gl.colors(2)].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
An object of class 'dist' giving distances between populations
}
\description{
This script calculates various distances between populations based on allele
frequencies (SNP genotypes) or frequency of presences in presence-absence data 
(Euclidean and Fixed-diff distances only).
}
\details{
The distance measure can be one of 'euclidean', 'fixed-diff', 'reynolds',
'nei' and 'chord'. Refer to the documentation of functions
  described in the the dartR Distance Analysis tutorial for algorithms
  and definitions.
}
\examples{
# SNP genotypes

D <- gl.dist.pop(possums.gl[1:90,1:100], method='euclidean')
\donttest{
D <- gl.dist.pop(possums.gl[1:90,1:100], method='euclidean',scale=TRUE)
D <- gl.dist.pop(possums.gl, method='nei')
D <- gl.dist.pop(possums.gl, method='reynolds')
D <- gl.dist.pop(possums.gl, method='chord')
D <- gl.dist.pop(possums.gl, method='fixed-diff')
#Presence-Absence data [only 10 individuals due to speed]
D <- gl.dist.pop(testset.gs[1:10,], method='euclidean')
res <- gl.dist.pop(platypus.gl)
}
}
\author{
author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
