% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initHMM.R
\name{gen_emis}
\alias{gen_emis}
\title{Generating the inital emission probability distribution of the covariates in TAN structure.}
\usage{
gen_emis(net, observation, sym)
}
\arguments{
\item{net}{Object of type 'bn' provided as output by \link{bnlearn}{model2network} showing the TAN structure between target variable and covariates.}

\item{observation}{Dataframe containing the discritized character values of only covariates at each node. Column names of dataframe should be same as the covariate names. Missing values should be denoted by "NA".}

\item{sym}{Character vector of possible values of target variable}
}
\value{
Inital emission probability distribution of the covariates in TAN structure
}
\description{
Generating the inital emission probability distribution of the covariates in TAN structure.
}
\examples{

library(bnlearn)

bnet = model2network("[A][C|A:B][D|A:C][B|A]") #A is the target variable while
                                               #B, C and D are covariates
obsvA=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")))
target_value= c("P","N")
prob= gen_emis(net=bnet,observation=obsvA,sym=target_value)
}
