% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covest.R
\name{Covest}
\alias{Covest}
\title{Regularized estimators for covariance  matrix.}
\usage{
Covest(Z, method = c("mv", "l2"), bandwidth = NULL)
}
\arguments{
\item{Z}{n*p matirx with sample size n and dimension p. 
Replicates for computing the covariance matrix, should be centered.}

\item{method}{methods used for estimating the covariance matrix.}

\item{bandwidth}{bandwidth for the "mv" estimator, 
default value are set to be list in (0.2, 0.5).}
}
\value{
regularized estimate of covariance matrix.
}
\description{
This function estimate the covariance matrix under l2 loss and 
minimum variance loss, provide linear shrinkage estimator under 
l2 loss and nonlinear shrinkage estimator under minimum variance loss.
}
\examples{
## randomly generate a n * p matrix where n = 50, p = 100
Z <- matrix(rnorm(50 * 100), nrow = 50, 100)
## linear shrinkage estimator under l2 loss
Cov.est <- Covest(Z, method = "l2")$output
## nonlinear shrinkage estimator under minimum variance loss
Cov.est <- Covest(Z, method = "mv", bandwidth = 0.35)$output
}
\references{
\itemize{ 
\item  Olivier Ledoit and Michael Wolf (2004),
A well-conditioned estimator for large-dimensional 
covariance matrices, \emph{Journal of multivariate analysis}, 88(2), 365--411.
\item Olivier Ledoit and Michael Wolf (2017), 
Direct nonlinear shrinkage estimation of 
large-dimensional covariance matrices, \emph{Working Paper No. 264, UZH}.
\item Li et al (2023),
Regularized fingerprinting in detection and attribution of climate change 
with weight matrix optimizing the efficiency in 
scaling factor estimation, \emph{Ann. Appl. Stat.} 17(1), 225--239.}
}
\author{
Yan Li
}
\keyword{estimation}
\keyword{variance}
