% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_cafs}
\alias{calc_cafs}
\title{Calculate CAFs}
\usage{
calc_cafs(
  pdf_u = NULL,
  pdf_l = NULL,
  rts_u = NULL,
  rts_l = NULL,
  one_cond,
  n_bins = NULL,
  b_coding
)
}
\arguments{
\item{pdf_u, pdf_l}{either NULL or density vectors}

\item{rts_u, rts_l}{either NULL or RT vectors}

\item{one_cond}{a label for the data.frame}

\item{n_bins}{the number of bins, default is 5}

\item{b_coding}{used for accessing the upper boundary label, determines
the corresponding column of the returned data.frame (e.g., P_\code{corr}).}
}
\value{
a data.frame with "Source", "Cond", "Bin"s, "P_<u_label>" for
the CAFs of type c("cafs", "sum_dist", "stats_dm", "data.frame")
}
\description{
Function that calls the underlying CAF calculation functions
\link{calc_cafs_obs} and \link{calc_cafs_pred}. Does input checks
and the data wrangling
}
\details{
if pdf_u and pdf_l are not NULL, returns CAFs of the densities

if rts_u and rts_l are not NULL, returns CAFs of the response times

if all are not NULL, returns both.
}
\seealso{
\code{\link[=new_stats_dm]{new_stats_dm()}}
}
\keyword{internal}
